/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.animations;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.vfx.MegaSpeechBubble;

public class ShoutAction
extends AbstractGameAction {
    private String msg;
    private boolean used = false;
    private static final float DEFAULT_DURATION = 2.0f;
    private float bubbleDuration;

    public ShoutAction(AbstractCreature source, String text, float duration, float bubbleDuration) {
        this.setValues(source, source);
        this.duration = !CardCrawlGame.fastMode ? duration : Settings.ACTION_DUR_LONG;
        this.msg = text;
        this.actionType = AbstractGameAction.ActionType.TEXT;
        this.bubbleDuration = bubbleDuration;
    }

    public ShoutAction(AbstractCreature source, String text) {
        this(source, text, 2.0f, 2.0f);
    }

    @Override
    public void update() {
        if (!this.used) {
            AbstractDungeon.effectList.add(new MegaSpeechBubble(this.source.hb.cX + this.source.dialogX, this.source.hb.cY + this.source.dialogY, this.bubbleDuration, this.msg, this.source.isPlayer));
            this.used = true;
        }
        this.tickDuration();
    }
}

